using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;

public partial class Tests_xmltest : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        
    }

    private void abc() {
        Response.Write("loading...<br/><br/>");
        XmlDocument oXmlDoc = new XmlDocument();
        
        oXmlDoc.Load(Server.MapPath(".") + "/Quran_Translation_Shakir.xml");

        if (oXmlDoc.SelectSingleNode("/tstmt/suracoll/sura").HasChildNodes)
        {
            foreach (XmlNode surah in oXmlDoc.SelectNodes("/tstmt/suracoll/sura"))
            if (surah.HasChildNodes) //surahs
            {
                XmlNode oxTitle = surah.SelectSingleNode("bktlong");
                string title = oxTitle.FirstChild.InnerText;
                Response.Write("Title: " + title + "<br/>");
                for (int i = 1; i < surah.ChildNodes.Count && i < 10; i++)
                //foreach (XmlNode oNode in root.ChildNodes) //title + verses
                {
                    foreach (XmlNode oNode in surah.SelectNodes("v"))// .ChildNodes[i];
                    Response.Write(i++ + " -> " + oNode.FirstChild.InnerText + "<br/>");
                }
                Response.Write("----end of surah---");
            }

        }
    }
    

    /*
        Private Sub RenderMenuTree()
        Dim dom As System.Xml.XmlDocument = New System.Xml.XmlDocument
        Try
            dom.Load(Server.MapPath("../Configuration/" & Convert.ToString(ViewState("MenuXmlFile"))))
        Catch ex As System.Exception
        End Try
        If dom.HasChildNodes Then
            Dim root As System.Xml.XmlNode = dom.FirstChild
            If root.HasChildNodes Then
                Dim i As Integer
                Try
                    For i = 0 To root.ChildNodes.Count - 1
                        If Not IsNothing(root.ChildNodes(i).Attributes("Visible")) AndAlso root.ChildNodes(i).Attributes("Visible").Value.ToUpper() <> "FALSE" Then
                            If Not IsNothing(root.ChildNodes(i).Attributes("SalesCenterID")) AndAlso root.ChildNodes(i).Attributes("SalesCenterID").Value <> lstSalesCenter.SelectedValue Then

                            Else
                                AppendNode(root.ChildNodes(i), UltraWebTree1.Nodes)
                            End If
                        End If
                    Next
                Catch ex As System.Exception
                End Try
            End If
        End If
    End Sub
     */
    protected void Button1_Click(object sender, EventArgs e)
    {
        Response.Write("loading...<br/><br/>");
        XmlDocument oXmlDoc = new XmlDocument();
        XmlTextWriter oWriter = new XmlTextWriter(Server.MapPath("Out_Quran_Shakir.xml"), System.Text.Encoding.ASCII);

        XmlWriterSettings oxSettings = new XmlWriterSettings();
        oxSettings.NewLineHandling = NewLineHandling.Entitize;
        oxSettings.Indent = true;
        oxSettings.NewLineOnAttributes = true;
        //oxSettings.IndentChars = ("\t");
        //oxSettings.NewLineChars = ("\n");
        oWriter.Formatting = Formatting.Indented;

        oWriter.WriteStartDocument();
        oWriter.WriteStartElement("quran");

        oXmlDoc.Load(Server.MapPath(".") + "/Quran_Translation_Shakir.xml");

        if (oXmlDoc.SelectSingleNode("/tstmt/suracoll/sura").HasChildNodes)
        {
            foreach (XmlNode surah in oXmlDoc.SelectNodes("/tstmt/suracoll/sura"))
                if (surah.HasChildNodes) //surahs
                {
                    oWriter.WriteStartElement("surah");
                    XmlNode oxTitle = surah.SelectSingleNode("bktlong");
                    string title = oxTitle.FirstChild.InnerText;
                    oWriter.WriteAttributeString("title", title);
                    //Response.Write("Title: " + title + "<br/>");
                    //for (int i = 1; i < surah.ChildNodes.Count; i++)
                    //foreach (XmlNode oNode in root.ChildNodes) //title + verses
                    {
                        int i = 0;
                        foreach (XmlNode oNode in surah.SelectNodes("v"))
                        { // .ChildNodes[i];
                            oWriter.WriteStartElement("verse");
                            i++;
                            oWriter.WriteAttributeString("id", i.ToString());
                            oWriter.WriteAttributeString("text", oNode.FirstChild.InnerText);
                            oWriter.WriteEndElement();//verse
                        }
                        //Response.Write(i++ + " -> " + oNode.FirstChild.InnerText + "<br/>");
                    }
                    oWriter.WriteEndElement();//surah
                    //Response.Write("----end of surah---");
                }

        }

        oWriter.WriteEndElement();
        oWriter.WriteEndDocument();
        oWriter.Close();
        Response.Write("done");
    }

    //arabic test
    protected void Button2_Click(object sender, EventArgs e)
    {
        Response.Write("loading...<br/><br/>");
        XmlDocument oXmlDoc = new XmlDocument();

        XmlWriterSettings oxSettings = new XmlWriterSettings();
        oxSettings.NewLineHandling = NewLineHandling.Entitize;
        oxSettings.Indent = true;
        oxSettings.NewLineOnAttributes = true;
        //oxSettings.IndentChars = ("\t");
        //oxSettings.NewLineChars = ("\n");

        oXmlDoc.Load(Server.MapPath(".") + "/test_arabic.xml");

        if (oXmlDoc.SelectSingleNode("/quran/sura").HasChildNodes)
        {
            foreach (XmlNode surah in oXmlDoc.SelectNodes("/quran/sura"))
                if (surah.HasChildNodes) //surahs
                {
                    XmlTextWriter oWriter = new XmlTextWriter(Server.MapPath("Quran_Surah_" + surah.Attributes["id"].ToString() + ".xml"), System.Text.Encoding.UTF8);
                    oWriter.WriteStartDocument();
                    oWriter.WriteStartElement("sura");
                    oWriter.WriteAttributeString("name", surah.Attributes["name"].ToString());
                    oWriter.Formatting = Formatting.Indented;

                    //Response.Write("Title: " + title + "<br/>");
                    //for (int i = 1; i < surah.ChildNodes.Count; i++)
                    //foreach (XmlNode oNode in root.ChildNodes) //title + verses
                    {
                        int i = 0;
                        foreach (XmlNode oNode in surah.SelectNodes("aya"))
                        { // .ChildNodes[i];
                            oWriter.WriteStartElement("aya");
                            i++;
                            oWriter.WriteAttributeString("id", i.ToString());
                            oWriter.WriteAttributeString("qurantext", oNode.FirstChild.InnerText);
                            oWriter.WriteEndElement();//verse
                        }
                        //Response.Write(i++ + " -> " + oNode.FirstChild.InnerText + "<br/>");
                    }
                    oWriter.WriteEndElement();//surah
                    oWriter.WriteEndDocument();
                    oWriter.Close();

                }

        }

        Response.Write("done");
    }
}
